function [gray_wwf,fpi_pixel,fpi_contour,edge_wwf] = segment_fpi(wwf_cropR,mask_wwfR)

%% Segments the firing pin impression from the non-illumination corrected region of interest

%% input
% wwf_cropR : tightly cropped registered/unregistered non-illumination
%             corrected region of interest consisting of the breech face region,
%             flowback and firing pin impression
%
% mask_wwfR : binary mask of wwf_cropR
%% output
% gray_wwf  : grayscale representation of  wwf_cropR using values in the
%             range 0-255
% fpi_pixel : fpi region segmented using pixel-based strategy
% fpi_contour : fpi region segmented using contour-based strategy
% edge_wwf : continuous outermost edge of registered/unregistered region of
%            interest consisting of the breech face, flowback and firing pin
%            impression

BF_FP1=convertMat2gray(wwf_cropR);
gray_wwf=uint8(255.*BF_FP1);
BF_FPd=double(gray_wwf);
[r1 c1]=size(wwf_cropR);

% Trace edge of the ROI
J=zeros(r1,c1);
J(~isnan(wwf_cropR))=1;
B=bwconncomp(J,8);

J=imfill(J,'holes');
EJ=edge(J,'Sobel');
EJE=bwmorph(EJ,'endpoints');

% to avoid using inbuilt find fuction use find_logical

%[xxw yyw zzw]=find(EJE==1);
[xxw,yyw] = find_logical(EJE);
endpointSet=[yyw xxw];  % endpoints

EndP1=endpointSet;
W=[];
%% To close the overall outline of ROI if it is not continuous
t=size(EndP1,1);
if isempty(EndP1)==0 
   while t>1
    % find closest endpoint for a given endpoint
     Point1=EndP1(1,:);
     Arr3=EndP1(2:end,:);
     %find closest endpoint
     [domp,minI]=min(sum((Arr3-Point1).^2,2));
     Point2=Arr3(minI,:);
     W=[W; Point1 Point2];
     Acomm1=intersect(Point2,Arr3,'rows');
     Arr4=setxor(Arr3,Acomm1,'rows');
     EndP1=Arr4;
     Arr3=[];
     t=size(EndP1,1);
   end
end


% Closing open contours
EJclosed =insertShape(double(EJ),'line',W); % even if W is empty that is the edge is continuous ,this line of code still works
edge_wwf=im2bw(EJclosed);    

Prop=regionprops(B,'Centroid');

CentroidC=Prop(1).Centroid;


Cp=imcontour(gray_wwf,'ShowText','on');
SA=getcontourlines(Cp); % get contourlines

[r1 c1]=size(wwf_cropR);


%Binary representation of contour
J4=zeros(r1,c1);

Ag=[];
for i=1:length(SA)
    if SA(i).v~=0
        for k1=1:length(SA(i).x)
            J4(round(SA(i).y(k1)),round(SA(i).x(k1)))=1;%for FP
            AllCP=unique([round(SA(i).x(k1)) round(SA(i).y(k1))],'rows');
            Ag=[Ag;AllCP];
        end
   end
end

%% Identifies closed contours- not affected by presence of spurs
closedst =[];
 for cc=1:length(SA)
     SDXn=round(SA(cc).x);
     SDXn=SDXn';
     SDYn=round(SA(cc).y);
     SDYn=SDYn';
     Im6=zeros(r1,c1);
     for i=1:length(SDYn)
         Im6(SDYn(i),SDXn(i))=1;
     end
     
     [xxx yyy]=find_logical(Im6);
     IIm=imfill(Im6,'holes');
     [xx1 yy1]=find_logical(IIm);
     
     if length(xx1)>length(xxx)
         closedst(cc)=1;
     else
         closedst(cc)=0;
     end
 end
 
 % Only keep the closed contours and reject all others %SA1c
v1=[];
xxc=[];
yyc=[];
 for i=1:length(SA)
     if closedst(i)==1          
         v1=[v1; {SA(i).v}];
         xxc=[xxc; {SA(i).x}];
         yyc=[yyc; {SA(i).y}];
     end
 end
 SA1c=struct('v',v1,'x',xxc,'y',yyc); % only closed(closedst) contours
 
% Find all closed components(i.e. closedst components) that enclose no other closed contours
 Encloses={};encloseSS=[];
 for i=1:length(SA1c)
     vx=[];
     Sgx=round(SA1c(i).x);
     Sgx=Sgx';
     Sgy=round(SA1c(i).y);
     Sgy=Sgy';
     Iy=zeros(r1,c1);
     for vi=1:length(Sgx)
         Iy(Sgy(vi),Sgx(vi))=1;
     end
     Iyt=imfill(Iy,'holes');
     [xxi yyi]=find_logical(Iyt==1);
     for j=1:length(SA1c)
         if j~=i 
             Sgx1=round(SA1c(j).x);
             Sgx1=Sgx1';
             Sgy1=round(SA1c(j).y);
             Sgy1=Sgy1';
             Iy1=zeros(r1,c1);
             for v1=1:length(Sgx1)
                 Iy1(Sgy1(v1),Sgx1(v1))=1;
             end
             [xxj yyj]=find_logical(Iy1==1);
             BQ=[yyj xxj];
             AQ=[yyi xxi];
             p=tocheckifSubset(BQ,AQ);
             if p==1
               vx=[vx j];
             end
         end
     end
   Encloses{i}=vx;
   encloseSS(i)=sum(vx);% If vx sums to zero then the closed contours enclose no other closed contours
 end
 
% Components that do not enclose any other components are represented as 1
% in the 'enclose'logical variable
 enclose=encloseSS'==0;

% Indices of closed contours that do not enclose any other closed contours
 [xe ye]=find_logical(encloseSS'==0); 
 
% find mean area of closed non-enclosing contours(encloseSS components
% having zero value)
 G=[];
 for r=1:length(xe)
     Sddx=round(SA1c(xe(r)).x);
     Sddx=Sddx';
     Sddy=round(SA1c(xe(r)).y);
     Sddy=Sddy';
     Ij=zeros(r1,c1);
     for h=1:length(Sddx)
         Ij(Sddy(h),Sddx(h))=1;
     end
     [xxn yyn]=find_logical(Ij==1);
     G(r)=length(xxn);  % length of non-enclosing closed contours
 end
mG=mean(G); % mean length of non-enclosing closed contours
   
% Include the non-enclosing contours having length greater than the
% threshold(mG) + all other closed enclosing contours in SA2c structure

v1=[];
xxc=[];
yyc=[];
for i=1:length(SA1c)
    if enclose(i)==1
        Snx=[SA1c(i).x];
        Snx=round(Snx');
        Sny=[SA1c(i).y];
        Sny=round(Sny');
        Iq=zeros(r1,c1);
        for  m=1:length(Snx)
            Iq(Sny(m),Snx(m))=1;
        end
        
        [xwe ywe]=find_logical(Iq==1);
        l=length(xwe);
        if l>=mG
            v1=[v1; {SA1c(i).v}];
            xxc=[xxc; {SA1c(i).x}];
            yyc=[yyc; {SA1c(i).y}];
        end
    else
        v1=[v1; {SA1c(i).v}];
        xxc=[xxc; {SA1c(i).x}];
        yyc=[yyc; {SA1c(i).y}];
    end
    
end

 SA2c=struct('v',v1,'x',xxc,'y',yyc);


  EnclosedBy=cell(length(SA2c),1);
 for r=1:length(SA2c)
     t=[];
      Im=zeros(r1,c1);
         %Take a single contour
         SDXr=[SA2c(r).x];
         SDXr=round(SDXr');
         SDYr=[SA2c(r).y];
         SDYr=round(SDYr');
         for  m=1:length(SDXr)
             Im(SDYr(m),SDXr(m))=1;
             
         end
         [xx11 yy11]=find_logical(Im==1);
         for c=1:length(SA2c)
             %Find out the contours that enclose it
             if c~=r
                 SDXc=[SA2c(c).x];
                 SDXc=round(SDXc');
                 SDYc=[SA2c(c).y];
                 SDYc=round(SDYc');
                 Im2=zeros(r1,c1);
                 for  n=1:length(SDXc)
                     Im2(SDYc(n),SDXc(n))=1;
                 end
                 Im3=imfill(Im2,'holes');
                 [xx21 yy21]= find_logical(Im3==1);
                  AG=[yy21 xx21];
                  BG=[yy11 xx11];
                 p1=tocheckifSubset(BG,AG);
                 if p1==1
                     t=[t c];
                 end
             end
             %end
         end
     
        
     EnclosedBy{r}=t;
     
 end
 
 
 %% Find contours that have maximum enclosings
 
 % if only one contour has maximum enclosings - select it as FPI core
 % else select the contour with the largest Solidity
 
 B=[];mmi=0;
 if checkCellArrayEmpty(EnclosedBy)==0
     for j1=1:length(EnclosedBy)
         
         B(j1)=length(EnclosedBy{j1});
     end
     
     [mmty mmtz]=max(B);
     
     [aaa bbb]= find_logical(B==mmty);
     
     if length(bbb)>1
         an=[];an1=[];
         for c2=1:length(bbb)
             SDXc=[SA2c(bbb(c2)).x];
             SDXc=round(SDXc');
             SDYc=[SA2c(bbb(c2)).y];
             SDYc=round(SDYc');
             Im2=zeros(r1,c1);
             for  n=1:length(SDXc)
                 Im2(SDYc(n),SDXc(n))=1;
             end
             Im3=imfill(Im2,'holes');
              sf{c2}=regionprops(Im3,'all');
             % an(c2)=sf{c2}.Area/sf{c2}.ConvexArea;
             an1(c2)= SA2c(bbb(c2)).v;
             an(c2)=sf{c2}.Area;
         end
         aj=min(an1);
         ya=(an1==aj);
         [y_x y_y]=find_logical(an1==aj);
         % If  more than 1 has minimum depth value , look for solidity
         if sum(ya)>1
             am=max(an.*ya);
             [y_x1 y_y1]=find_logical(an==am);
             mmi=bbb(y_y1);
         else
            mmi=bbb(y_y);
         end
             
           
     else
         mmi=bbb;
     end
 else
     sf=cell(length(SA2c),1);
     an=zeros(length(SA2c),1);
     for c2=1:length(SA2c)
         SDXc=[SA2c(c2).x];
         SDXc=round(SDXc');
         SDYc=[SA2c(c2).y];
         SDYc=round(SDYc');
         Im2=zeros(r1,c1);
         for  n=1:length(SDXc)
             Im2(SDYc(n),SDXc(n))=1;
         end
         Im3=imfill(Im2,'holes');
         sf{c2}=regionprops(Im3,'all');
         an(c2)=sf{c2}.Area/sf{c2}.ConvexArea;
     end
     [aj ah ]=max(an);
     mmi=ah;
     
 end
%mmi id the seed for the firing pin
Im5=zeros(r1,c1);
 arr_x=SA2c(mmi).x;
 SMx=round(arr_x);
 SMx=SMx';
 arr_y=SA2c(mmi).y;
 SMy=round(arr_y);
 SMy=SMy';
 for t2=1:length(SMx)
     Im5(SMy(t2),SMx(t2))=1;
 end
 
Im5=imfill(Im5,'holes');
 
[xxP yyP]=find_logical(Im5);
%  
%  
% %For the winning seed find all closed contours
% % 
% 
  FPI=zeros(r1,c1);
  EnclosingST=[]; % contains loops + other structures
%  % Find all closed structures that enclose the seed
%  % seed
  for t=1:length(SA)
%      %[xx yy zz]=find(Im5==1); % getting the contour  points for the winning curve
      if closedst(t)==1
          SDXi=round(SA(t).x);
          SDXi=SDXi';
         SDYi=round(SA(t).y);
         SDYi=SDYi';
         Im10=zeros(r1,c1);
         for i=1:length(SDYi)
             Im10(SDYi(i),SDXi(i))=1;
         end
         Im10=imfill(Im10,'holes');
         [xx3 yy3 ]=find_logical(Im10);
         %if length(xx3)>=length(xx)  % only those contours that enclose the seed
         p = tocheckifSubset([yyP xxP],[yy3 xx3]);
            if p==1
                EnclosingST = [EnclosingST t];
            end
        % end
     end
 end
 ar=[];
 FPI=Im5;
 % sort by area
 if isempty(EnclosingST)==0
     if length(EnclosingST)>1
         for i=1:length(EnclosingST)
             a=EnclosingST(i);
             SDXa=round(SA(a).x);
             SDXa=SDXa';
             SDYa=round(SA(a).y);
             SDYa=SDYa';
             Im11=zeros(r1,c1);
             for j=1:length(SDXa)
                 Im11(SDYa(j),SDXa(j))=1;
             end
             Im11=imfill(Im11,'holes');
             [xxv yyv]=find_logical(Im11);
             ar(i)=length(xxv);
         end
     else
         a=EnclosingST(1);
         SDXa=round(SA(a).x);
         SDXa=SDXa';
         SDYa=round(SA(a).y);
         SDYa=SDYa';
         for j=1:length(SDXa)
             FPI(SDYa(j),SDXa(j))=1;
         end
     end
 end
 
 [Arrv Arri]=sort(ar,'ascend');
 % find distance between adjacent enclosing structures
 ditn=[]; Contour={};
 if isempty(Arri)==0
     for h=1:length(Arri)-1
         xn=EnclosingST(Arri(h));
         xn1=EnclosingST(Arri(h+1));
         Sxxn=round(SA(xn).x);
         Sxxn=Sxxn';
         Syyn=round(SA(xn).y);
         Syyn=Syyn';
         
         Sxxn1=round(SA(xn1).x);
         Sxxn1=Sxxn1';
         Syyn1=round(SA(xn1).y);
         Syyn1=Syyn1';
         Im8=zeros(r1,c1);
         for ii=1:length(xn)
             Im8(Syyn(ii),Sxxn(ii))=1;
         end
         Im9=zeros(r1,c1);
         for jj=1:length(xn1)
             Im9(Syyn1(jj),Sxxn1(jj))=1;
         end
         [xxn yyn]=find_logical(Im8);
         [xxn1 yyn1]=find_logical(Im9);
         dism=[];
         for t=1:length(xxn)
             for b=1:length(xxn1)
                 dism(t,b)= (sum(([yyn(t) xxn(t)]-[yyn1(b) xxn1(b)]).^2,2)).^0.5;
             end
         end
        % ditn(h)=mean(mean(dism));
        ditn(h)=mean(min(dism,[],2));
         Contour{h}=[xn xn1];
     end
 end
 dii=[];
% This is to remove extreme boundaries
 if isempty(ditn)==0 & length(ditn)>=2
     for j=1:length(ditn)-1
         if ditn(j)>=ditn(j+1)
           if sum(ismember(dii,ditn(j)))==0 
            dii=[dii ditn(j)];
           end
           if sum(ismember(dii,ditn(j+1)))==0 
            dii=[dii ditn(j+1)];
           end
         else
             if sum(ismember(dii,ditn(j)))==0
                 dii=[dii ditn(j)];
             end
             break;
         end
     end
 end
 Value=mean(dii);
% For contours towards the edge
 [xw yw]=find_logical(edge_wwf);
 AB=EnclosingST(Arri);
 dm=[];
 SQ=[]; % consists of contours close to the edge;
 if isempty(AB)==0
 for g=1:length(EnclosingST)
     Sdx=round(SA(AB(g)).x);
     Sdx=Sdx';
     Sdy=round(SA(AB(g)).y);
     Sdy=Sdy';
     Imp=zeros(r1,c1);
     for y=1:length(Sdx)
         Imp(Sdy(y),Sdx(y))=1;
     end
     [xt yt]=find_logical(Imp);
     dS=[];
     for u=1:length(xt)
         for v=1:length(xw)
             dS(u,v)= (sum(([yt(u) xt(u)]-[yw(v) xw(v)]).^2,2)).^0.5;
         end
     end
     dm(g)=mean(min(dS,[],2));
     %dm(g)=mean(mean(dS));
     if dm(g)<Value
         SQ=[SQ AB(g)];
     end
 end
 end
 
 
 Lr=dm>Value; %to include binary(1,0)       
 AB1=AB.*Lr; % to include
 
 Lr1=dm<Value; %to include binary(1,0)       
 AB2=AB.*Lr1; % to include  
 
 distin=[];
 Cod=[];
 if isempty(ditn)==0 & length(ditn)>=2
     for j=1:length(ditn)-1
        
         if ditn(j)>=ditn(j+1) 
             %xv0=Contour{j}(1);
             xv=Contour{j}(2);
             %if sum(ismember(
          if isempty(setdiff(xv,SQ))==0
             SCx=round(SA(xv).x);
             SCx=SCx';
             SCy=round(SA(xv).y);
             SCy=SCy';
             for t=1:length(SCx)
               FPI(SCy(t),SCx(t))=1;
             end
              if sum(ismember(Cod,Contour{j}(2)))==0
                 Cod=[Cod Contour{j}(2)];
              end
          end
          
             xv1=Contour{j}(1);
            if isempty(setdiff(xv1,SQ))==0
             SCx1=round(SA(xv1).x);
             SCx1=SCx1';
             SCy1=round(SA(xv1).y);
             SCy1=SCy1';
             for t=1:length(SCx1)
               FPI(SCy1(t),SCx1(t))=1;
             end
             
             
              if sum(ismember(Cod,Contour{j}(1)))==0
                 Cod=[Cod Contour{j}(1)];
             end
             
          end
             
             
             
             
         else
             
                 xv1=Contour{j+1}(1);
              if isempty(setdiff(xv1,SQ))==0
                 SBx=round(SA(xv1).x);
                 SBx=SBx';
                 SBy=round(SA(xv1).y);
                 SBy=SBy';
                 for t=1:length(SBx)
                     FPI(SBy(t),SBx(t))=1;
                 end
                 if sum(ismember(Cod,Contour{j+1}(1)))==0
                     Cod=[Cod Contour{j+1}(1)];
                 end
             end
             break;
         end
     end
     
 else
     for i=1:length(ditn)
         xv=Contour{i}(2);
         Scx=round(SA(xv).x);
         Scx=Scx';
         Scy=round(SA(xv).y);
         Scy=Scy';
         for n=1:length(Scx)
         FPI(Scy(n),Scx(n))=1;
         end
     end
     
 end
 
 %Reorder Cod based on area
 AreaW=[];
 for i=1:length(Cod)
     Sax=round(SA(Cod(i)).x);
     Sax=Sax';
     Say=round(SA(Cod(i)).y);
     Say=Say';
     Iu=zeros(r1,c1);
     for q=1:length(Sax)
         Iu(Say(q),Sax(q))=1;
     end
     IU=imfill(Iu,'holes');
     [xx6 yy6]=find_logical(IU);
     AreaW(i)=length(xx6);
 end
 [av ai]=sort(AreaW,'ascend');
   
Cod=Cod(ai);
Cod_take=[];
if isempty(Cod)==0 & length(Cod)>=2
    for i=1:length(Cod)-1
        level=SA(Cod(i)).v;
        level1=SA(Cod(i+1)).v;
        if i==1
            if level1>level
                Cod_take(i)=1;
                Cod_take(i+1)=1;
            elseif level1==level
                sdx=SA(Cod(i)).x;
                sdx=round(sdx');
                sdy=SA(Cod(i)).y;
                sdy=round(sdy');
                Imm=zeros(r1,c1);
                for q=1:length(sdx)
                 Imm(sdy(q),sdx(q))=1;
                end
                Immf=imfill(Imm,'holes');
                sdx1=SA(Cod(i+1)).x;
                sdx1=round(sdx1');
                sdy1=SA(Cod(i+1)).y;
                sdy1=round(sdy1');
                Inn=zeros(r1,c1);
                for q1=1:length(sdx1)
                 Inn(sdy1(q1),sdx1(q1))=1;
                end
                Innf=imfill(Inn,'holes');
                En=Innf-Immf;
                [xxr yyr]=find_logical(En);
                 Cn=[];
                for ll=1:length(SA)
                    if closedst(ll)==1
                        if ll~=Cod(i) | ll~=Cod(i+1)
                            svx=SA(ll).x;
                            svx=round(svx');
                            svy=SA(ll).y;
                            svy=round(svy');
                            Imj=zeros(r1,c1);
                            for ii=1:length(svx)
                                Imj(svy(ii),svx(ii))=1;
                            end
                            [xxd yyd]=find_logical(Imj);
                            p3=tocheckifSubset([yyd xxd],[yyr xxr]);
                            if p3==1
                                Cn=[Cn ll];
                            end
                        end
                    end
                end
                            ch=0;
                            if isempty(Cn)==0
                                for f=1:length(Cn)
                                   lk=SA(Cn(f)).v;
                                   if lk>level1
                                       ch=ch+1;
                                   end
                                end
                            end
                            if ch>0
                                Cod_take(i)=1;
                                Cod_take(i+1)=0;
                                break;
                            else
                                Cod_take(i)=1;
                                Cod_take(i+1)=1;
                                break;
                            end
            
            else
                Cod_take(i)=1;
                Cod_take(i+1)=0;
                break;
            end
        else   
        if level1>level
            Cod_take(i)=1;
            Cod_take(i+1)=1;
        elseif level1==level
                sdx=SA(Cod(i)).x;
                sdx=round(sdx');
                sdy=SA(Cod(i)).y;
                sdy=round(sdy');
                Imm=zeros(r1,c1);
                for q=1:length(sdx)
                 Imm(sdy(q),sdx(q))=1;
                end
                Immf=imfill(Imm,'holes');
                sdx1=SA(Cod(i+1)).x;
                sdx1=round(sdx1');
                sdy1=SA(Cod(i+1)).y;
                sdy1=round(sdy1');
                Inn=zeros(r1,c1);
                for q1=1:length(sdx1)
                 Inn(sdy1(q1),sdx1(q1))=1;
                end
                Innf=imfill(Inn,'holes');
                En=Innf-Immf;
                [xxr yyr]=find_logical(En);
                 Cn=[];
                for ll=1:length(SA)
                    if closedst(ll)==1
                        if ll~=Cod(i) | ll~=Cod(i+1)
                            svx=SA(ll).x;
                            svx=round(svx');
                            svy=SA(ll).y;
                            svy=round(svy');
                            Imj=zeros(r1,c1);
                            for ii=1:length(svx)
                                Imj(svy(ii),svx(ii))=1;
                            end
                            [xxd yyd]=find(Imj);
                            p3=tocheckifSubset([yyd xxd],[yyr xxr]);
                            if p3==1
                                Cn=[Cn ll];
                            end
                        end
                    end
                end
                            ch=0;
                            if isempty(Cn)==0
                                for f=1:length(Cn)
                                   lk=SA(Cn(f)).v;
                                   if lk>level1
                                       ch=ch+1;
                                   end
                                end
                            end
                            if ch>0
                                Cod_take(i)=1;
                                Cod_take(i+1)=0;
                                break;
                            else
                                Cod_take(i)=1;
                                Cod_take(i+1)=1;
                                break;
                            end
            
        
        else
           Cod_take(i)=1;
           Cod_take(i+1)=0;
           break;
        end
        end
    end
end

%Refine FPI using Cod_take
if isempty(Cod_take)==0
    FPI=zeros(r1,c1);
     for i=1:length(Cod_take)
        if Cod_take(i)==1
            xv1=Cod(i);
            SBx=round(SA(xv1).x);
            SBx=SBx';
            SBy=round(SA(xv1).y);
            SBy=SBy';
            for t=1:length(SBx)
                FPI(SBy(t),SBx(t))=1;
            end
        end
    end
end

fpi_contour=imfill(FPI,'holes');
fpi_contour=bwmorph(fpi_contour,'clean');

% For the masked image of original segment
%% this step is important for discontinuous/broken Breech Face for example image 1060
 %% BF_FP_mask added to edge EJbw that is dilated by se.The border cleared for pixel based FPI region selection
% se=strel('disk',4);
%  BQ=imdilate(EJbw,se);
% % 
% BQ1=zeros(r1,c1);
% for i=1:r1
%     for j=1:c1
%         if BQ(i,j)==1
%             BQ1(i,j)=255;
%         end
%     end
% end
%  Anew=BF_FP_mask+uint8(BQ1);
FF1=imclearborder(~mask_wwfR);
FF11=bwmorph(FF1,'clean');

fpi_pixel=zeros(r1,c1);
FF2=zeros(r1,c1);
[xx5 yy5]=find_logical(FF11);
if isempty(xx5)==0
    BwLab=bwlabel(FF11,8);
    DV=regionprops(BwLab,'all');
    FF3=zeros(r1,c1);
    if length(DV)>1
        tc=cat(2,DV(:).Area);
        [agg agi]=max(tc);
        
        for j=1:size(DV(agi).PixelList,1)
            FF3(DV(agi).PixelList(j,2),DV(agi).PixelList(j,1))=1;
        end
        fpi_pixel=FF3;
    else
        fpi_pixel=FF11;
    end

end
